// routes/ideas.js
const express = require('express');
const router = express.Router();
const jwt = require("jsonwebtoken");
const User = require("../models/User");
const Startup = require("../models/Startup")
// Secret key for JWT (reuse from your auth file)
const JWT_SECRET = "a718bcb1b57b40f14d4f20ef5eec3f47dfc19d484b190d4407e9040e2e3dc61b0d02c1aa389337eb78627c955b7b483a69f745065a15e56e58123ca76b8de94d";

// Middleware to verify token
const verifyToken = (req, res, next) => {
  const token = req.header("Authorization")?.replace("Bearer ", "");
  if (!token) return res.status(401).json({ message: "Access denied. No token provided." });

  try {
    const decoded = jwt.verify(token, JWT_SECRET);
    req.userId = decoded.id; // Extract user ID from token
    next();
  } catch (error) {
    res.status(400).json({ message: "Invalid token." });
  }
};

// Dashboard route
router.get("/get-profile", verifyToken, async (req, res) => {
  try {
    const user = await User.findById(req.userId);
    if (!user) return res.status(404).json({ message: "User not found." });
    if (user) {
      Startup.findOne({ email: user.email })
    }
    
      console.log(`user----32-----,profile------>`,user); 
    
    res.status(200).json(user);
  } catch (error) {
    console.error("Error fetching user details:", error.message);
    res.status(500).json({ message: "Server error." });
  }
});

module.exports = router;
