const express = require("express");
const bcrypt = require("bcrypt");
const jwt = require("jsonwebtoken");
const User = require("../models/User");
const router = express.Router();

// Secret key for JWT
const JWT_SECRET = "a718bcb1b57b40f14d4f20ef5eec3f47dfc19d484b190d4407e9040e2e3dc61b0d02c1aa389337eb78627c955b7b483a69f745065a15e56e58123ca76b8de94d";

//Registration Route
router.post("/register", async (req, res) => {
  const { name, email, password, ...otherFields } = req.body;

  try {
    const existingUser = await User.findOne({ email });
    if (existingUser) {
      return res.status(400).json({ message: "User with this email already exists." });
    }

    // Hash the password
    const hashedPassword = await bcrypt.hash(password, 10);

    // Include `name` field in the new user data
    const newUser = new User({ name, email, password: hashedPassword, ...otherFields });

    await newUser.save();
    res.status(201).json({ message: "User registered successfully!" });
  } catch (error) {
    console.error("Registration error:", error.message);
    res.status(500).json({ message: "Server error, please try again later." });
  }
});


// Login route
router.post("/login", async (req, res) => {
  const { email, password } = req.body;

  try {
    // Find user by email
    const user = await User.findOne({ email });

    console.log("----->", user)
    if (!user) {
      return res.status(404).json({ message: "User not found" });
    }

    // Check if password matches
    const isMatch = await bcrypt.compare(password, user.password);
    if (!isMatch) {
      return res.status(401).json({ message: "Invalid credentials" });
    }

    // Check if user is registered in the category
    const isRegisteredInCategory = !!user.category; // Assuming 'category' field exists in the User model
    console.log("=====>", user._id)
    // Generate JWT token
    const token = jwt.sign(
      { id: user._id, isRegisteredInCategory },
      JWT_SECRET,
      { expiresIn: "1h" }
    );
    console.log("token", token)
    res.status(200).json({
      token,
      email: user.email,
      isRegisteredInCategory,
      userType: user.usertype,
      message: "Login successful!"
    });
  } catch (error) {
    console.error("Login error: ", error.message);
    res.status(500).json({ message: "Server error, please try again later." });
  }
});

// Middleware to verify token
const verifyToken = (req, res, next) => {
  const token = req.header("Authorization")?.replace("Bearer ", "");
  if (!token) return res.status(401).json({ message: "Access denied. No token provided." });

  try {
    const decoded = jwt.verify(token, JWT_SECRET);
    req.userId = decoded.id; // Extract user ID from token
    next();
  } catch (error) {
    res.status(400).json({ message: "Invalid token." });
  }
};

// Dashboard route
router.get("/dashboard", verifyToken, async (req, res) => {
  try {
    const user = await User.findById(req.userId).select("name email");
    if (!user) return res.status(404).json({ message: "User not found." });
    res.status(200).json(user); // Send user data
  } catch (error) {
    console.error("Error fetching user details:", error.message);
    res.status(500).json({ message: "Server error." });
  }
});


module.exports = router;
