const Investor = require('../models/Investor');
const User = require('../models/User');

const registerInvestor = async (req, res) => {
  try {
    const { contactInfo, category, interest } = req.body;

    // Parse JSON fields (received as strings from FormData)
    const parsedContactInfo = JSON.parse(contactInfo);
    const parsedInterest = JSON.parse(interest);

     // Debug uploaded file
     console.log('Uploaded file:', req.file);

    // Create a new investor document
    const newInvestor = new Investor({
      contactInfo: parsedContactInfo,
      category,
      interest: parsedInterest,
      profilePicture: req.file ? `/uploads/${req.file.filename}` : null, // Fallback to default
    });

    // Save to database
    const savedInvestor = await newInvestor.save();
    await User.updateOne({ email: req.body.email }, { $set: { usertype: "Investor" } })

    res.status(201).json({
      message: 'Investor registered successfully',
      investor: savedInvestor,
    });
  } catch (error) {
    console.error('Error registering investor:', error.message);
    res.status(500).json({ message: 'Error registering investor', error: error.message });
  }
};

const getAllInvestors = async (req, res) => {
  try {
    const investors = await Investor.find();
    res.status(200).json({ investors });
  } catch (error) {
    console.error('Error fetching investors:', error.message);
    res.status(500).json({ message: 'Error fetching investors', error: error.message });
  }
};

module.exports = {
  registerInvestor,
  getAllInvestors,
};
