from fastapi import FastAPI
from app.routers.UserRouter import router as user_router
from app.routers.productRouter import router as product_router
from app.routers.productVariantRouter import router as product_variant_router
from app.routers.cartRouter import router as cart_router
from app.routers.bannerRouter import router as banner_router
from app.routers.AdminRouter import router as admin_router
from app.routers.categoryRouter import router as category_router
from app.routers.blogRouter import router as blog_router
from app.routers.searchRouter import router as search_router
from app.routers.ShippingRouter import router as shipping_router
from app.routers.OrderRouter import router as order_router
from app.routers.subadmin import router as subadmin_router
import uvicorn
app = FastAPI(title="Nbitz API")

app.include_router(user_router)
app.include_router(admin_router)
app.include_router(product_router)
app.include_router(product_variant_router)
app.include_router(cart_router)
app.include_router(banner_router)
app.include_router(category_router)
app.include_router(blog_router)
app.include_router(search_router)
app.include_router(shipping_router)
app.include_router(subadmin_router)
app.include_router(order_router)
@app.get("/")
def root():
    return {"status": "ok"}

if __name__ == "__main__":
    uvicorn.run("main:app", host="127.0.0.1", port=5002, reload=True)