from pydantic import BaseModel, Field
from typing import List, Optional
from datetime import datetime

class SubAdmin(BaseModel):
    name: str
    username: str
    password: str
    role: str = "subadmin"
    createdAt: datetime = Field(default_factory=datetime.utcnow)
    updatedAt: datetime = Field(default_factory=datetime.utcnow)

class SubAdminLoginRequest(BaseModel):
    username: str
    password: str

class SubAdminLoginResponse(BaseModel):
    id: str
    name: str
    username: str
    role: str
    createdAt: datetime
    updatedAt: datetime