from pydantic import BaseModel, Field, EmailStr
from typing import List, Optional
from datetime import datetime

class ProductVariant(BaseModel):
    variant_Type: str  # e.g., Size, Color , weight
    variant_Values: str # e.g , Large, Red , 500g
    price: float
    offer_price: Optional[float] = None
    offer_percentage: Optional[float] = None
    sku: Optional[str] = None
    stock: int
    total_sold : int = 0
    variant_url: Optional[str] = None
    schema_markup: Optional[str] = None
    createdAt: datetime = Field(default_factory=datetime.utcnow)
    updatedAt: datetime = Field(default_factory=datetime.utcnow)