from pydantic import BaseModel, Field
from typing import List, Optional
from datetime import datetime

class Product(BaseModel):
    p_name: str
    p_short_description: str
    p_detailed_description: str
    p_category: str
    p_sub_category: str
    p_Product_Type: str = 'product'
    p_url: str
    p_meta_Title: Optional[str] = None
    p_meta_Description: Optional[str] = None
    p_meta_Keywords: Optional[List[str]] = None
    p_schema_Markup: Optional[str] = None
    p_free_delivery: bool = False
    p_is_50_voucher: bool = False
    p_is_100_voucher: bool = False
    p_images: List[str] = Field(default_factory=list)
    createdAt: datetime = Field(default_factory=datetime.utcnow)
    updatedAt: datetime = Field(default_factory=datetime.utcnow)