from datetime import datetime
from typing import Dict, List, Optional

from bson import ObjectId
from pydantic import BaseModel, Field


class PaymentSummary(BaseModel):
    amount: float
    currency: str = "INR"
    status: str = "pending"
    reference: Optional[str] = None
    provider: Optional[str] = None


class orders(BaseModel):
    user: Optional[ObjectId] = Field(None, alias="user")
    orderItems: Optional[List[Dict]] = []
    shippingAddress: Optional[Dict] = None
    paymentMethod: Optional[str] = None
    paymentResult: Optional[PaymentSummary] = None
    itemsPrice: Optional[float] = 0
    shippingFee: Optional[float] = 0
    platformFee: Optional[float] = 0
    totalPrice: Optional[float] = 0
    trackingNumber: Optional[str] = None
    status: str = "pending"
    returnItems: Optional[float] = 0
    createdAt: datetime = Field(default_factory=datetime.utcnow)
    updatedAt: datetime = Field(default_factory=datetime.utcnow)