from pydantic import BaseModel, Field, EmailStr
from typing import List, Optional
from datetime import datetime

class Category(BaseModel):
    category_name: str
    category_image: Optional[str] = None
    status: bool = True
    createdAt: datetime = Field(default_factory=datetime.utcnow)
    updatedAt: datetime = Field(default_factory=datetime.utcnow)
    product_list: List[str] = Field(default_factory=list)

class SubCategory(BaseModel):
    sub_category_name: str
    sub_category_image: Optional[str] = None
    status: bool = True
    createdAt: datetime = Field(default_factory=datetime.utcnow)
    updatedAt: datetime = Field(default_factory=datetime.utcnow)
    product_list: List[str] = Field(default_factory=list)

    