from datetime import datetime
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, Field

class Blog(BaseModel):
    title: str
    content: str
    image: str
    blog_url: str
    blog_meta_title: Optional[str] = None
    blog_meta_description: Optional[str] = None
    blog_meta_keywords: Optional[List[str]] = None
    blog_schema_markup: Optional[str] = None
    createdAt: datetime = Field(default_factory=datetime.utcnow)
    updatedAt: datetime = Field(default_factory=datetime.utcnow)


    title: Optional[str] = None
    content: Optional[str] = None
    image: Optional[str] = None
    blog_url: Optional[str] = None
    blog_meta_title: Optional[str] = None
    blog_meta_description: Optional[str] = None
    blog_meta_keywords: Optional[List[str]] = None
    blog_schema_markup: Optional[str] = None