from pydantic import BaseModel, Field, EmailStr
from typing import List, Optional
from datetime import datetime 

class Admin(BaseModel):
    name: str
    username: str
    password: str
    role: str = "admin"
    createdAt: datetime = Field(default_factory=datetime.utcnow)
    updatedAt: datetime = Field(default_factory=datetime.utcnow)
    timestamp: datetime = Field(default_factory=datetime.utcnow)

# login
class AdminLoginRequest(BaseModel):
    username: str
    password: str

class AdminLoginResponse(BaseModel):
    access_token: str
    token_type: str = "bearer"

class AdminOut(BaseModel):
    id: str
    name: str
    username: str
    role: str
    createdAt: datetime
    updatedAt: datetime   

# create product
class AdminCreateProduct(BaseModel):
    name: str
    short_description: str
    detailed_description: str
    category: str
    sub_category: str
    url: str
    meta_Title: Optional[str] = None
    meta_Description: Optional[str] = None
    meta_Keywords: Optional[List[str]] = None
    schema_Markup: Optional[str] = None
    images: List[str] = Field(default_factory=list)
    createdAt: datetime = Field(default_factory=datetime.utcnow)
    updatedAt: datetime = Field(default_factory=datetime.utcnow)