from pydantic import BaseModel, Field, EmailStr
from typing import List, Optional
from datetime import datetime

# Wishlist item model
class WishlistItem(BaseModel):
    product: str  # MongoDB ObjectId stored as string
    variantId: Optional[str] = None
    addedAt: datetime = Field(default_factory=datetime.utcnow)

# Address model
class Address(BaseModel):
    type: str = Field(..., pattern="^(Home|Work|Other)$")
    street: str
    city: str
    state: str
    pincode: str
    country: str = "India"
    isDefault: bool = False
    name: str = ""
    mobile: int
    
# Main User model
class User(BaseModel):
    name: str
    email: EmailStr
    password: str
    role: str = "user"
    mobile: int
    isVerified: bool = False
    resetPasswordToken: Optional[str] = None
    resetPasswordExpires: Optional[datetime] = None
    wishlist: List[WishlistItem] = Field(default_factory=list)
    addresses: List[Address] = Field(default_factory=list)
    # walletBalance: float = 0.0
    createdAt: datetime = Field(default_factory=datetime.utcnow)
    updatedAt: datetime = Field(default_factory=datetime.utcnow)


# Request/Response Schemas
class UserCreate(BaseModel):
    name: str
    email: EmailStr
    password: str
    mobile: int


class UserOut(BaseModel):
    id: str
    name: str
    email: EmailStr
    role: str
    mobile: int
    isVerified: bool
    createdAt: datetime
    updatedAt: datetime


class LoginRequest(BaseModel):
    email: EmailStr
    password: str


class LoginResponse(BaseModel):
    access_token: str
    token_type: str = "bearer"
    user: UserOut


class EmailOtpVerify(BaseModel):
    email: EmailStr
    otp: str


class ForgotPasswordRequest(BaseModel):
    email: EmailStr


class ForgotPasswordVerify(BaseModel):
    email: EmailStr
    otp: str
    newPassword: str


class ResetPasswordRequest(BaseModel):
    currentPassword: str
    newPassword: str

class userUpdateProfile(BaseModel):
    name : Optional[str]
    email : Optional[str]
    mobile: Optional[int] 
class UserAddAddress(BaseModel):
    type: str = Field(..., pattern="^(Home|Work|Other)$")
    street: str
    city: str
    state: str
    pincode: str
    country: str = "India"
    isDefault: bool = False
    name: str = ""
    mobile: int

class UserUpdateAddress(BaseModel):
    type: Optional[str] = Field(None, pattern="^(Home|Work|Other)$")
    street: Optional[str] = None
    city: Optional[str] = None
    state: Optional[str] = None
    pincode: Optional[str] = None
    country: Optional[str] = "India"
    isDefault: Optional[bool] = None
    name: Optional[str] = None
    mobile: Optional[int] = None

class addToWishlistRequest(BaseModel):
    productId: str
    variantId: Optional[str] = None

class removeFromWishlistRequest(BaseModel):
    productId: str
    variantId: Optional[str] = None
