from datetime import datetime
from typing import Optional

from pydantic import BaseModel, EmailStr, Field


class ShippingAddress(BaseModel):
    fullName: str
    phone: str
    email: Optional[EmailStr] = None
    addressLine1: str
    addressLine2: Optional[str] = None
    city: str
    state: str
    postalCode: str
    country: str = "India"
    landmark: Optional[str] = None


class ShippingFee(BaseModel):
    state: str
    combo_fee: float
    delivery_fee: float
    above_500_fee: float
    createdAt: datetime = Field(default_factory=datetime.utcnow)
    updatedAt: datetime = Field(default_factory=datetime.utcnow)


class ShippingFeeResponse(ShippingFee):
    id: str