import os
from typing import Optional

from pymongo import MongoClient

MONGO_URI: str = os.getenv("MONGO_URI", "mongodb+srv://kairaaharish:kairaaharish2024@cluster0.a1eik.mongodb.net/")
MONGO_DB_NAME: str = os.getenv("MONGO_DB_NAME", "nbitz")

_client: Optional[MongoClient] = None


def get_client() -> MongoClient:
    global _client
    if _client is None:
        _client = MongoClient(MONGO_URI)
    return _client


def get_db():
    return get_client()[MONGO_DB_NAME]


def get_col(collection_name: str):
    return get_db()[collection_name]

